#region AuthorHeader
//
//	EvoSystem version 2.1, by Xanthos
//
//
#endregion AuthorHeader
using System;
using Server;
using Server.Mobiles;
using Server.Network;
using Server.Targeting;
using Server.Commands;
using Xanthos.Interfaces;
using Server.Gumps;

namespace Xanthos.Evo
{
	public class EvoCommands
	{
		public static void Initialize()
		{
			CommandHandlers.Register( "EP", AccessLevel.Player, new CommandEventHandler( EP_OnCommand ) );
		}

		public static void EP_OnCommand( CommandEventArgs args )
		{
			PlayerMobile from = args.Mobile as PlayerMobile;

			if( from != null )
				from.Target = new InternalTarget( from );
		}

		private class InternalTarget : Target
		{
			public InternalTarget( Mobile from ) : base( 8, false, TargetFlags.None )
			{
				from.SendMessage ( "Target an Evo creature you control to see its experience points." );
			}

			protected override void OnTarget( Mobile from, object obj )
			{
				IEvoCreature evo = obj as IEvoCreature;
				BaseCreature c = obj as BaseCreature;

				if ( !from.Alive )
					from.SendMessage( "You may not do that while dead." );

				else if ( null == evo || null == c )
					from.SendMessage( "That is not an Evo creature!" );

				else if ( from.AccessLevel == AccessLevel.Player && ( c.Controlled == false || c.ControlMaster != from ))
					from.SendMessage( "You do not control that creature!" );

				else if ( c is BaseEvoMount )
                c.PublicOverheadMessage( MessageType.Regular, c.SpeechHue, true, c.Name +" has "+ evo.Ep.ToString("N0", Auberon.Chat.General.Nfi) +" experience points.", false );
            else
				{
					BaseEvo ev = (BaseEvo) c;
               BaseEvoSpec spec = ev.GetEvoSpec();
					
					if ( null != spec && null != spec.Stages )
					{
						BaseEvoStage stage = spec.Stages[ ev.Stage ];

						if ( null != stage )
						{
// 							from.SendMessage( 193, "EVOLUTION INFO:" );
//                      from.SendMessage( 193, "{0} [Level {1}/{2}]", c.Name.ToUpper(), evo.Stage + 1, ev.FinalStage + 1 );
// 							from.SendMessage( 193, "Experience: {0}", evo.Ep );
// 							
// 							if ( ev.Stage < ev.FinalStage  )
// 								from.SendMessage( 193, "Next level: {0}", stage.NextEpThreshold );

							string str = String.Format( "{0} [Level {1} / {2}] EVOLUTION:<br><br>", c.Name.ToUpper(), evo.Stage + 1, ev.FinalStage + 1 );
							str = str + String.Format( "<basefont color=white>Experience: {0}<br>", evo.Ep.ToString("N0", Auberon.Chat.General.Nfi) );
							
							if ( ev.Stage < ev.FinalStage  )
								str = str + String.Format( "Next level: {0}", stage.NextEpThreshold.ToString("N0", Auberon.Chat.General.Nfi) );
								
                     from.CloseGump( typeof(NoticeGump) );
                     from.SendGump( new NoticeGump( 1060637, 30720, str, 0xFFC000, 320, 180, null, null ) );
						}
					}
					//                c.PublicOverheadMessage( MessageType.Regular, c.SpeechHue, true, c.Name +" has "+ evo.Ep +" experience points.", false );
				}
			}
		}
	}
}
